//[BotStacks Chat SDK](../../index.md)/[ai.botstacks.sdk.ui.components](index.md)/[Avatar](-avatar.md)

# Avatar

[common]\

@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)

fun [Avatar](-avatar.md)(modifier: [Modifier](https://developer.android.com/reference/kotlin/androidx/compose/ui/Modifier.html) = Modifier, size: [AvatarSize](-avatar-size/index.md) = AvatarDefaults.Size, user: [User](../ai.botstacks.sdk.state/-user/index.md), showOnlineStatus: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = true, isSelected: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false, isRemovable: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false)

Avatar

Renders the display image for a user in a bordered circle at the specified size.

This is a convenience wrapper around [User](../ai.botstacks.sdk.state/-user/index.md) to handle [OnlineStatus](../ai.botstacks.sdk.state/-online-status/index.md) easily.

#### Parameters

common

| | |
|---|---|
| modifier | the Modifier to be applied to this Avatar |
| size | Size to display |
| user | User for the avatar |
| showOnlineStatus | if enabled, the online status indicator will show if not UNKNOWN. |
| isSelected | Whether to show the selected state for this avatar (checkmark in bottom right). |
| isRemovable | Whether to show the removable state for this avatar (x in bottom right).<br>NOTE: isSelected and isRemovable supersede online status indicator. |

[common]\

@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)

fun [Avatar](-avatar.md)(modifier: [Modifier](https://developer.android.com/reference/kotlin/androidx/compose/ui/Modifier.html) = Modifier, size: [AvatarSize](-avatar-size/index.md) = AvatarDefaults.Size, status: [OnlineStatus](../ai.botstacks.sdk.state/-online-status/index.md) = OnlineStatus.Unknown, url: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, chat: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false)

Avatar

Renders the display image for a given URL in a bordered circle at the specified size.

#### Parameters

common

| | |
|---|---|
| modifier | the Modifier to be applied to this Avatar |
| size | Size to display |
| status | optional online status |
| url | The URL of the image to render. |
| chat | Whether or not this Avatar is for a chat. True for a channel, group, false for a user, DM. |

[common]\

@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)

fun [Avatar](-avatar.md)(modifier: [Modifier](https://developer.android.com/reference/kotlin/androidx/compose/ui/Modifier.html) = Modifier, backgroundColor: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = AvatarDefaults.BackgroundColor, contentColor: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = AvatarDefaults.ContentColor, size: [AvatarSize](-avatar-size/index.md) = AvatarDefaults.Size, type: [AvatarType](-avatar-type/index.md), isSelected: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false, isRemovable: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false)

Avatar

Renders the display image for a user in a bordered circle at the specified size.

#### Parameters

common

| | |
|---|---|
| modifier | the Modifier to be applied to this Avatar |
| backgroundColor | Background color to render behind images (will show in empty state depending on what empty state is). |
| contentColor | Content color for items rendered in empty state. |
| size | Size to display |
| type | Type definition for this Avatar. |
| isSelected | Whether to show the selected state for this avatar (checkmark in bottom right). |
| isRemovable | Whether to show the removable state for this avatar (x in bottom right). |
